/*

 * Script table des matires. Ce script est publi sous licence GPL
 * article : http://giminik.developpez.com/articles/javascript-dom/table-des-matieres/
 * date : 2005-09-14
 * http://www.gnu.org/copyleft/gpl.html
 * Vous pouvez le modifier librement et le redistribuer.
 * Merci de m'indiquer tout bug, incompatibilit, amlioration 
 *  giminik   at   redaction-developpez.com
 */

/* Cette fonction permet d'afficher/cacher le contenu d'un lment dont on
 * connat l'identifiant : containerId. Ici, on s'en sert pour cacher la 
 * liste de liens. En mme temps, le nom de classe de l'lment titre de
 * la liste est modifi afin de pouvoir lui affecter un style CSS.
 * containerId : l'identifiant de l'lment html  afficher cacher.
 * classOpened : le nom de la classe  donner  l'lment html lorsqu'il est
 *               affich.
 * classClosed : le nom de la classe  donner  l'lment html lorsqu'il est 
 *               cach.
 */ 
function TCSwap(containerId, classOpened, classClosed) {

  /* ici pas de problme avec firefox concernant firstChild
   * et lastChild car la fonction agit sur des noeuds gnrs
   * via le DOM. Il n'y a donc pas de noeud #text pour chaque
   * saut de ligne entre les diffrentes balises HTML. */

  // rcupration de la liste de liens
  var linkList = document.getElementById(containerId).lastChild;

  // rcupration du titre de la liste
  var listTitle = document.getElementById(containerId).firstChild;

  // si la liste n'est pas cache
  if (linkList.style.display != 'none') {

    // on la cache
    linkList.style.display = 'none';

    // et on change la classe du titre (utile pour une feuille de style)
    listTitle.className = classClosed;

  }
  // si la liste n'est pas affiche
  else if (linkList.style.display != 'block') {

    // on l'affiche (type block)
    linkList.style.display = 'block';

    // et on change la classe du titre (utile pour une feuille de style)
    listTitle.className = classOpened;

  }

}


/* Cette fonction gnre la table des matire. Elle construit les lments
 * html et les insre dans l'arborescence du document.
 *
 * contentId : seuls les titres contenus dans l'lment (et ses sous lments)
 *             ayant comme id contentId seront utiliss pour la table des matires.
 *             ce doit tre un identifiant valide et existant.
 * insertBeforeId : la table des matires sera insre juste avant l'lment
 *                  portant cet identifiant. ce doit tre un identifiant
 *                  valide et existant.
 * containerId : le nom du conteneur sera celui pass en paramtre. cet
 *               identifiant ne doit pas dj tre utilis dans la page.
 * minHead : par exemple 5 pour titre h5 : les titres hirarchiquement infrieurs
 *           sont ignors. doit tre compris entre 1 et 6.
 * maxHead : par exemple 2 pour titre h2 : les titres hirarchiquement suprieurs
 *           sont ignors. doit tre compris entre 1 et 6 et doit tre infrieur
 *            minHead.
 * tableHeadLevel : un titre est insr pour annoncer la table des matires.
 *                  utilisez 3 pour que le titre de cette table des matires soit
 *                  h3. doit tre compris entre 1 et 6.
 * clickable : boolen indique si la table des matires est rtractable sur
 *             l'vnement click. doit prendre comme valeur true ou false.
 */
function contentTable(contentId, insertBeforeId, containerId, minHead,
                      maxHead, tableHeadLevel, clickable) {

  // configuration, il est possible de les mettre en paramtre, mais je
  // prfre les laisser l pour ne pas surcharger le nombre d'arguments
  //  passer...

  // il s'agit du titre affich avant la table.
  var contentTableTitle = 'Table des matires';

  // il s'agit du prfixe utilis pour chaque ancre gnre.
  var anchorName = 'tableDesMatieres';

  // il s'agit du suffixe utilis pour chaque ancre gnre. ce chiffre est
  // incrment pour chaque ancre. il s'agit ici de la valeur initiale du
  // compteur.
  var anchorsNumberingBeginning = 0;

  // nom de classe que prend le titre lorsque la liste est dplie.
  // utile avec une feuille de style.
  var openedClass = 'ouvert';

  // nom de classe que prend le titre lorsque la liste est ferme.
  // utile avec une feuille de style.
  var closedClass = 'ferme';


  // pas de DOM, pas de table des matires
  if (!document.getElementById) return;


  // vrification de la plage des paramtres passs.
  // en cas d'erreur, utilisation des valeurs par dfaut.

  if (!minHead || minHead < 1 || minHead > 4) {
    minHead = 4;
  }

  if (!maxHead || maxHead < 1 || maxHead > minHead) {
    maxHead = 1;
  }

  if (!tableHeadLevel || tableHeadLevel < 1 || tableHeadLevel > 6) {
    tableHeadLevel = 2;
  }


  // vrification de la non existence de l'identifiant, si incorrect, on affiche
  // un message d'erreur et on quitte ensuite.
  if (document.getElementById(containerId)) {

    alert(containerId + ' already exists in this page!');
    return;

  }
  else if (!document.getElementById(insertBeforeId)) {

    alert(insertBeforeId + ' is not an existing id!');
    return;

  }
  else if (!document.getElementById(contentId)) {

    alert(contentId + ' is not an existing id!');
    return;

  }
  else {
    // l'affichage de la table des matires ne se fait que si l'identifiant
    // est unique afin que le document soit bien form et que l'identifiant
    // devant lequel on insre la table des matires existe.

    // cration d'un conteneur pour la table des matires
    var TCContainer = document.createElement('div');

    // on lui affecte l'id pass en paramtre
    TCContainer.id = containerId;


    // l'lment contenant les titres  rfrencer
    var content = document.getElementById(contentId);


    // tableau contenant les noeuds titres pour un accs direct
    var chapters = Array();


    // remplissage rcursif du tableau de noeuds titres
    headTag(content, chapters);


    // s'il y a moins de 2 titres, pas besoin de table des matires
    if (chapters.length < 2) return;


    // cration d'un titre pour la table des matires
    var TCTitle = document.createElement('h' + tableHeadLevel);
    TCTitle.appendChild(document.createTextNode(contentTableTitle));

    // ajout du titre dans la table des matires
    TCContainer.appendChild(TCTitle);


    // cration de la liste
    var theList = document.createElement('ul');


    if (clickable) {
        // si on indique que la table des matires doit se drouler au click

      // appel de la fonction TCSwap en passant le paramtre conteneur.
      TCTitle.onclick = function() { TCSwap(containerId, openedClass, closedClass) };

      // on donne au titre le nom de la classe qui indique qu'il est dpli
      // cela permettra notamment pas l'intermdiaire d'une feuille de style
      // d'insrer une image...
      TCTitle.className = openedClass;

      // vnements onclick sur la liste
      theList.onclick = function() { TCSwap(containerId, openedClass, closedClass) };

    }

    // pour chaque chapitres
    for (var i = 0; i < chapters.length; i++) {


      // on connat le numro du titre (h1) 1, (h2) 2, (h3) 3, (h4) 4, (h5) 5 ou (h6) 6
      var titleNumber = parseInt(chapters[i].nodeName.charAt(1));


      // si le titre est bien dans la plage donne par l'utilisateur
      if (titleNumber <= minHead && titleNumber >= maxHead) {

        // cration d'un lment de liste
        var anItem = document.createElement('li');


        // cration d'un lien et affectation du contenu (textuel uniquement) du titre correspondant
        var aLink = document.createElement('a');
        aLink.appendChild(document.createTextNode(inText(chapters[i])));

        // pour pouvoir exploiter la liste avec une feuille de style
        // on donne comme nom de classe  chaque lment de liste, le type de titre point (h1 - h6)
        anItem.className = chapters[i].nodeName.toLowerCase();


        // prparation des liens
        // si le titre possde dj un identifiant id, on l'utilise, sinon on en gnre un unique
        if (chapters[i].id) { // si l'id existe

          // on fait pointer le lien vers l'identifiant du titre correspondant
          aLink.href = '#' + chapters[i].id;

        }
        else { // on va devoir gnrer un id pour le titre

          // on gnre un identifiant unique
          // tant que l'identifiant existe dj, on boucle
          do {

            anchorsNumberingBeginning++;

          } while (document.getElementById(anchorName + anchorsNumberingBeginning))


          // une fois ici, l'identifiant gnr doit tre unique
          chapters[i].id = anchorName + anchorsNumberingBeginning;

          // on fait pointer le lien vers l'identifiant de cette page
          aLink.href = '#' + chapters[i].id;

        }

        // ajout du lien dans l'lment de liste
        anItem.appendChild(aLink);

        // ajout de l'lment de liste dans la liste
        theList.appendChild(anItem);

      }

    }

    // ajout de la liste dans le conteneur de liste
    TCContainer.appendChild(theList);

    // rcupration du parent contenant l'lment devant lequel on va insrer
    // la table des matires.
    var beforeElement = document.getElementById(insertBeforeId);

    // le parent dans lequel on va insrer la table des matires.
    var theParent = beforeElement.parentNode;

    // insertion de la table des matires.
    theParent.insertBefore(TCContainer, beforeElement);

  }

}




/* Cette fonction ajoute rcursivement la liste des balises d'enttes  l'intrieur 
 * d'un noeud dans le tableau pass en paramtres. Afin de conserver l'ordre et de 
 * prendre en compte tous les lments d'un noeud, cette fonction est rcursive.
 * node : Il s'agit du noeud dans lequel on recherche les lments titre.
 * headArray : Il s'agit du tableau dans lequel on va ajouter les noeuds
 *             des lments titre Hn.
 */
function headTag(node, headArray) {

  // le nombre de noeuds contenus dans le noeud pass en paramtre
  var childrenNumber = node.childNodes.length;

  // pour tous les noeuds enfants
  for (var i = 0; i < childrenNumber; i++) {

    // contient le noeud en cours
    var element = node.childNodes[i];

    // contient le nom du noeud en cours
    var elementName = element.nodeName.toLowerCase();

    // si c'est un titre hn
    if (elementName == 'h1' || elementName == 'h2' || elementName == 'h3' 
                            || elementName == 'h4' || elementName == 'h5' 
                            || elementName == 'h6') {

      // on ajoute le noeud titre dans le tableau
      // headArray.push(element); <-- non compatible avec IE 5 donc :
      headArray[headArray.length] = element;

      // un titre ne peut tre contenu dans un autre titre, la rcursivit s'arrte ici.

    }
    else {

      // appel rcursif  la procdure
      headTag(element, headArray);

    }

  }

}


/* Cette fonction retourne le texte contenu dans un noeud, uniquement le texte.
 * Le texte est pur de toutes les balises intermdiaires.
 * node : le noeud pour lequel on ne souhaite rcuprer que la partie textuelle.
 */
function inText(node) {

  // le nombre de noeuds contenus dans le noeud pass en paramtre
  var childrenNumber = node.childNodes.length;

  // la chane (contenant le texte des balises) que l'on retourne
  var foundString = "";

  // rcursivit : si pas de noeud on retourne le texte
  // sinon on retourne le rsultat de la fonction excut sur tous les sous noeuds
  if (childrenNumber == 0) { // pas d'enfants dans le noeud
    // on renvoie la valeur textuelle contenue dans le noeud
    return node.nodeValue;
  }
  else { // il y a des enfants, on les parcourt tous

    // pour chaque noeud fils
    for (var i = 0; i < childrenNumber; i++) {

      // on concatne  ce qui a dj t trouve le rsultat de la fonction appele rcursivement
      foundString += inText(node.childNodes[i]);

    }

    // on renvoie le rsultat
    return foundString;

  }

}